#!/bin/bash

ifconfig eth0 txqueuelen 60000
ifconfig eth1 txqueuelen 60000
ifconfig eth6 txqueuelen 60000
ifconfig eth11 txqueuelen 60000

echo 1 > /proc/sys/net/ipv4/conf/eth0/arp_ignore
echo 1 > /proc/sys/net/ipv4/conf/eth1/arp_ignore
echo 1 > /proc/sys/net/ipv4/conf/eth6/arp_ignore
echo 1 > /proc/sys/net/ipv4/conf/eth11/arp_ignore

echo 2 > /proc/sys/net/ipv4/conf/eth0/arp_announce
echo 2 > /proc/sys/net/ipv4/conf/eth1/arp_announce
echo 2 > /proc/sys/net/ipv4/conf/eth6/arp_announce
echo 2 > /proc/sys/net/ipv4/conf/eth11/arp_announce

ethtool -C eth0 rx-usecs 100
ethtool -C eth1 rx-usecs 100
ethtool -C eth6 rx-usecs 100
ethtool -C eth11 rx-usecs 100

ethtool -G eth0 rx 4096 tx 4096
ethtool -G eth1 rx 4096 tx 4096
ethtool -G eth6 rx 4096 tx 4096
ethtool -G eth11 rx 4096 tx 4096

ifconfig eth0 mtu 1500
ifconfig eth1 mtu 1500
ifconfig eth6 mtu 1500
ifconfig eth11 mtu 1500

./set_irq_affinity.sh -x local eth0 eth1 eth6 eth11
