#!/bin/sh
#
# Script to create oracle database

# Configurable Parameters 
LOGSZ="800000M"
TEMPSZ="100000M"
UNDOSZ="250000M"

if [ $# -ne 1 ]
then
        echo "Usage: createdb.sh <database dir>"
        exit 1
fi

if [ "$ORACLE_HOME" = "" ]
then
        echo "$ORACLE_HOME"
        echo "You must set the ORACLE_HOME environment variable"
        exit 1
fi

if [ "$ORACLE_SID" = "" ]
then
        echo "$ORACLE_SID"
        echo "You must set the ORACLE_SID environment variable"
        exit 1
fi

####################
# Set the database and database directory vars
#####################
DB=${ORACLE_SID}
DB_DIR=$1

####################################
# Check to see that the target database directory
# exists and has write permission.
####################################
if [ ! -d "$DB_DIR" ]
then
        echo "$DB_DIR does not exist. Please create it first."
        exit 1
fi


########################################################
# Go and run the create_init.sh script
# to build the correct pfiles and .ora files for Oracle 
########################################################
if [ ! -f "$ORACLE_HOME/dbs/init${DB}.ora" ]
then
        echo "$ORACLE_HOME/dbs/init${DB}.ora does not exist. Please create it first."
        exit 1
fi

DB_DIR="+DATA"
SYS=${DB_DIR}/sys_${DB}
SYS_AUX=${DB_DIR}/sysaux_${DB}

LOG_DIR="+REDO"
LOG1=${LOG_DIR}/log1_1_${DB}
LOG2=${LOG_DIR}/log1_2_${DB}

DB_DIR="+DATA"
TEMP=${DB_DIR}/temp_${DB}
UNDO1=${DB_DIR}/undo1_${DB}
UNDO2=${DB_DIR}/undo2_${DB}

# Create database
sqlplus <<EOT
CONNECT / as sysdba
shutdown;
startup nomount

CREATE DATABASE SPECDB
CONTROLFILE REUSE
LOGFILE GROUP 1 '${LOG1}' SIZE ${LOGSZ} REUSE,
        GROUP 2 '${LOG2}' SIZE ${LOGSZ} REUSE
MAXDATAFILES 200
DATAFILE '${SYS}' size 4000M REUSE
SYSAUX DATAFILE '${SYS_AUX}' size 8000M REUSE
BIGFILE DEFAULT TEMPORARY TABLESPACE temp_ts
    TEMPFILE '${TEMP}' SIZE ${TEMPSZ} REUSE
BIGFILE UNDO TABLESPACE undo_ts1 DATAFILE '${UNDO1}'  SIZE ${UNDOSZ} REUSE
    BLOCKSIZE 8k;
CREATE BIGFILE UNDO TABLESPACE undo_ts2 DATAFILE '${UNDO2}'  SIZE ${UNDOSZ} REUSE
    BLOCKSIZE 8k;

exit
EOT


echo "Running catalog scripts ..."
sqlplus <<EOT
CONNECT / as sysdba
@?/rdbms/admin/catalog;
@?/rdbms/admin/catexp.sql
@?/rdbms/admin/catldr.sql
@?/rdbms/admin/catproc.sql
@?/rdbms/admin/catparr.sql
@?/rdbms/admin/utlmontr;
EXIT
EOT

echo "Catalog done."

sqlplus <<EOT
CONNECT / as sysdba
drop user spec;
CREATE USER spec IDENTIFIED BY spec;
GRANT CONNECT, RESOURCE TO spec;
GRANT ALL PRIVILEGES TO spec IDENTIFIED BY spec;

ALTER USER spec
        TEMPORARY TABLESPACE temp_ts;
EXIT
EOT

