/*
 *   SPECjEnterprise2010 - a benchmark for enterprise middleware
 *  Copyright 1995-2010 Standard Performance Evaluation Corporation
 *   All Rights Reserved
 *
 * This source code is provided as is, without any express or implied warranty.
 *
 *  History:
 *  Date        ID, Company               Description
 *  ----------  ------------------------  ----------------------------------------------
 *  2003/01/01  John Stecher, IBM         Created for SPECjAppServer2004
 *  2003/12/02  Samuel Kounev, Darmstadt  Added second addInventory() method for completed LOs
 *  2003/05/05  John Stecher, IBM         Made changes to ensure that users are updated when car is sold out from
 *                                        under them with a warning message.
 *  2003/06/17  John Stecher, IBM         Updated to make better use of BigDecimal
 *  2003/06/28  John Stecher, IBM         Removed unnecessary imports
 *  2003/08/30  John Stecher, IBM         Updated for new sell functionality
 *  2003/12/15  John Stecher, IBM         Changed for Atomicity Test
 *  2003/01/08  John Stecher, IBM         Changed code to eliminate unused objects being passed into methods
 *
 */

package org.spec.jent.ejb.orders.session;

import java.math.BigDecimal;
import java.util.List;

import org.spec.jent.common.SPECjEnterpriseException;
import org.spec.jent.ejb.orders.entity.Customer;
import org.spec.jent.ejb.orders.entity.CustomerInventory;
import org.spec.jent.ejb.orders.entity.Item;
import org.spec.jent.ejb.shoppingcart.entity.ShoppingCart;

public interface CustomerService {
    /**
     * Get the customer with given identifier.
     * @return null if no Customer exists with given identifier.
     */
    public Customer getCustomer(Integer userID);
    
    /**
     * Gets the number of Customer.
     */
    public long countCustomer();
    
    /**
     * Validates that a Customer with given identifier exists.
     */
    public boolean validateCustomer(Integer userID);
    
    /**
     * Gets all inventory for the customer with given identifier.
     */
    public List<CustomerInventory> getInventories(Integer userID);
    
    /**
     * Gets a random Customer who has available credit more than given limit.
     */
    public Customer selectCustomerWithGoodCredit(BigDecimal limit);

    /**
     * Affirms the Customer with given identifier has more credit than given
     * limit.
    */
    public boolean checkCustomerCredit(int userID, BigDecimal limit);

    /**
     * Sells inventory 
     * @param userID
     * @param inventoryID
     * @param rollback
     * @return
     */
    public boolean sellInventory(Integer userID, Long inventoryID, 
            boolean rollback);
    
    /**
     * 
     * @param custID
     * @param sc
     * @param orderCost
     * @param atomicityTest
     * @throws SPECjEnterpriseException
     */
    public void addInventory(Integer custID, ShoppingCart sc, 
            BigDecimal orderCost, boolean atomicityTest);
    
    /**
     * Add inventory
     * @param custId
     * @param itemId
     * @param quantity
     * @param totalValue
     */
    public void addInventory(Integer custId, Item item, int quantity, 
            BigDecimal totalValue);
}
