/*
 *   SPECjEnterprise2010 - a benchmark for enterprise middleware
 *  Copyright 1995-2010 Standard Performance Evaluation Corporation
 *   All Rights Reserved
 *
 * This source code is provided as is, without any express or implied warranty.
 *
 *  History:
 *  Date        ID, Company             Description
 *  ----------  ----------------        ----------------------------------------------
 *  2003/01/01  John Stecher, IBM       Created for SPECjAppServer2004
 *  2003/03/26  John Stecher, IBM       Added Big Decimal Support
 *  2003/04/30  John Stecher, IBM       moved to helper package
 *  2003/06/28  John Stecher, IBM       Removed unnecessary imports
 */

package org.spec.jent.ejb.orders.entity;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Comparator;

import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.IdClass;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.persistence.TableGenerator;
import javax.persistence.Version;

/**
 * Maintains inventory for a {@link Customer}. Should only be constructed by 
 * a Customer and hence constructors have package-level access.
 *  
 * A typical example of a persistent entity that acts as a detail for a 
 * bi-directional Master-Detail pattern.
 * 
 * @see Customer#addCustomerInventory(String, int, BigDecimal)
 * 
 */
@NamedQueries({
    @NamedQuery(name="CustomerInventory.selectAll",
        query="select a from CustomerInventory a"),
    @NamedQuery(name=CustomerInventory.QUERY_COUNT,
        query="select COUNT(a) from CustomerInventory a")
})
@SuppressWarnings("serial")
@Entity 
@Table(name="O_CUSTINVENTORY")
@IdClass(CustomerInventoryPK.class)
public class CustomerInventory implements Serializable, 
    Comparator<CustomerInventory> {

    public static final String QUERY_COUNT = "CustomerInventory.count";
	
    @Id
    @TableGenerator(name="inventory",
            table="U_SEQUENCES",
            pkColumnName="S_ID",
            valueColumnName="S_NEXTNUM",
            pkColumnValue="inventory",
            allocationSize=1000)
    @GeneratedValue(strategy=GenerationType.TABLE,generator="inventory")
    @Column(name="CI_ID")
    private Long         id;

    @Id
    @Column(name = "CI_CUSTOMERID", insertable = false, updatable = false)
    private int             custId;
    
    @ManyToOne(cascade=CascadeType.MERGE)
    @JoinColumn(name="CI_CUSTOMERID")
    private Customer        customer;
    
    @ManyToOne(cascade=CascadeType.MERGE)
    @JoinColumn(name = "CI_ITEMID")
    private Item            vehicle;
    
    @Column(name="CI_VALUE")
    private BigDecimal      totalCost;

    @Column(name="CI_QUANTITY")
    private int             quantity;
      
    @Version 
    @Column(name = "CI_VERSION")
    private int             version;

    protected CustomerInventory() {
    }

    CustomerInventory(Customer customer, Item vehicle, int quantity, 
            BigDecimal totalValue) {
        this.customer = customer;
        this.vehicle = vehicle;
        this.quantity = quantity;
        this.totalCost = totalValue;
    }

    public Item getVehicle() {
        return vehicle;
    }

    public BigDecimal getTotalCost() {
        return totalCost;
    }

    public int getQuantity() {
        return quantity;
    }

    public Long getId() {
        return id;
    }

    public Customer getCustomer() {
        return customer;
    }
    
    public int getCustId() {
    	return custId;
    }

    public int getVersion() {
        return version;
    }
    
    public int compare(CustomerInventory cdb1, CustomerInventory cdb2) {
        return cdb1.id.compareTo(cdb2.id);
    }

    @Override
    public boolean equals (Object obj) {
        if (obj == this)
            return true;
        if (obj == null || !(obj instanceof CustomerInventory)) 
            return false;
        if (this.id == ((CustomerInventory)obj).id)
          return true;
        if (this.id != null && ((CustomerInventory)obj).id == null)
          return false;
        if (this.id == null && ((CustomerInventory)obj).id != null)
          return false;
        
        return this.id.equals(((CustomerInventory)obj).id);
    }
}
