#!/bin/sh
#
SUDO=/usr/local/bin/sudo
ZNAME=jent

# reset config
$SUDO psrset -d 1 2 3 4
$SUDO psradm -an

# create 1x (57-strand) psets per chip
# leave 7 strands per chip for NICs
$SUDO psrset -c 7-63
$SUDO psrset -c 71-127
$SUDO psrset -c 135-191
$SUDO psrset -c 199-255

# disable intrs in psets
$SUDO psrset -f 1
$SUDO psrset -f 2
$SUDO psrset -f 3
$SUDO psrset -f 4

# bind processes in the 4 zones to the psets
#
PSET=1
for Z in 51 52 53 54
do
        ZONENAME=$ZNAME$Z
        echo "Binding processes in $ZONENAME to processor set $PSET"
        PIDS=`pgrep -z $ZONENAME`
        for P in $PIDS
        do
                $SUDO /usr/sbin/psrset -b $PSET $P
        done
        PSET=`expr $PSET + 1`
        if [ $PSET -gt 4 ]; then
		PSET=1
        fi
done

