
DROP TABLE S_component;
CREATE TABLE S_component
(
	COMP_ID			char(15) not null,
	COMP_NAME		char(10),
	COMP_DESC		varchar(100),
	COMP_UNIT		char(10),
	COMP_COST		numeric(9,2),
	QTY_ON_ORDER	integer,
	QTY_DEMANDED	integer,
	LEAD_TIME		integer,
	CONTAINER_SIZE	integer,
	primary key (COMP_ID)
) TYPE = InnoDB;

/* CREATE UNIQUE INDEX S_COMP_IDX ON S_component (COMP_ID); */

DROP TABLE S_supp_component;
CREATE TABLE S_supp_component
(
	SC_P_ID			char(15) not null,
	SC_SUPP_ID		integer not null,
	SC_PRICE		numeric(9,2),
	SC_QTY			integer,
	SC_DISCOUNT		numeric(6,4),
	SC_DEL_DATE		integer,
	primary key (SC_P_ID, SC_SUPP_ID)
) TYPE = InnoDB;

/* CREATE UNIQUE INDEX S_SC_IDX ON S_supp_component (SC_P_ID, SC_SUPP_ID); */

DROP TABLE S_supplier;
CREATE TABLE S_supplier
(
	SUPP_ID			integer not null,
	SUPP_NAME		char(16),
	SUPP_STREET1	char(20),	
	SUPP_STREET2	char(20),	
	SUPP_CITY		char(20),	
	SUPP_STATE		char(2),	
	SUPP_COUNTRY	char(10),	
	SUPP_ZIP		char(9),	
	SUPP_PHONE		char(16),
	SUPP_CONTACT	char(25),
	primary key (SUPP_ID)
) TYPE = InnoDB;

/* CREATE UNIQUE INDEX S_SUPP_IDX ON S_supplier (SUPP_ID); */

DROP TABLE S_site;
CREATE TABLE S_site
(
	SITE_ID			integer not null,
	SITE_NAME		char(16),
	SITE_STREET1	char(20),	
	SITE_STREET2	char(20),	
	SITE_CITY		char(20),	
	SITE_STATE		char(2),	
	SITE_COUNTRY	char(10),	
	SITE_ZIP		char(9),
	primary key (SITE_ID)
) TYPE = InnoDB;

/* CREATE UNIQUE INDEX S_site_IDX ON S_site (SITE_ID); */

DROP TABLE S_purchase_order;
CREATE TABLE S_purchase_order
(
	PO_NUMBER		integer not null,
	PO_SUPP_ID		integer,
	PO_SITE_ID		integer,
	primary key (PO_NUMBER)
) TYPE = InnoDB;

/* CREATE UNIQUE INDEX S_PO_IDX ON S_purchase_order (PO_NUMBER); */

DROP TABLE S_purchase_orderline;
CREATE TABLE S_purchase_orderline
(
	POL_NUMBER		integer not null,
	POL_PO_ID		integer not null,
	POL_P_ID		char(15),
	POL_QTY			integer,
	POL_BALANCE		numeric(9,2),
	POL_DELDATE		date,
	POL_MESSAGE		varchar(100),
	primary key (POL_PO_ID, POL_NUMBER)
) TYPE = InnoDB;

/* CREATE UNIQUE INDEX S_POL_IDX ON S_purchase_orderline (POL_PO_ID, POL_NUMBER); */

