DROP TABLE M_parts;
CREATE TABLE M_parts
(
	P_ID		char(15) not null,
	P_NAME		char(10),
	P_DESC		varchar(100),
	P_REV		char(6),
	P_PLANNER	integer,
	P_TYPE		integer,
	P_IND		integer,
	P_LOMARK	integer,
	P_HIMARK	integer,
	primary key (P_ID)
) TYPE = InnoDB;

/* CREATE UNIQUE INDEX M_parts_IDX ON M_parts (P_ID); */

DROP TABLE M_bom;
CREATE TABLE M_bom
(
	B_COMP_ID	char(15) not null,
	B_ASSEMBLY_ID	char(15) not null,
	B_LINE_NO	integer,
	B_QTY		integer,
	B_OPS		integer,	
	B_ENG_CHANGE	char(10),	
	B_OPS_DESC	varchar(100),
	primary key (B_ASSEMBLY_ID, B_COMP_ID, B_LINE_NO)
) TYPE = InnoDB;

/* CREATE UNIQUE INDEX M_bom_IDX ON M_bom (B_ASSEMBLY_ID, B_COMP_ID, B_LINE_NO); */

DROP TABLE M_workorder;
CREATE TABLE M_workorder
(
	WO_NUMBER	integer not null,
	WO_O_ID		integer,
	WO_OL_ID	integer,
	WO_STATUS	integer,
	WO_ASSEMBLY_ID	char(15),
	WO_ORIG_QTY	integer,
	WO_COMP_QTY	integer,
	WO_DUE_DATE	date,
	WO_START_DATE	datetime,
	primary key (WO_NUMBER)
) TYPE = InnoDB;

/* CREATE UNIQUE INDEX M_WO_IDX ON M_workorder (WO_NUMBER); */

DROP TABLE M_largeorder;
CREATE TABLE M_largeorder
(
	LO_ID		integer not null,
	LO_O_ID		integer,
	LO_OL_ID	integer,
	LO_ASSEMBLY_ID	char(15),
	LO_QTY		integer,
	LO_DUE_DATE	date,
	primary key (LO_ID)
) TYPE = InnoDB;

/* CREATE UNIQUE INDEX M_LO_IDX on M_largeorder(LO_ID); */

DROP TABLE M_inventory;
CREATE TABLE M_inventory
(
	IN_P_ID		char(15) not null,
	IN_QTY		integer,
	IN_ORDERED	integer,
	IN_LOCATION	char(20),	
	IN_ACC_CODE	integer,
	IN_ACT_DATE	date,
	primary key (IN_P_ID)
) TYPE = InnoDB;

/* CREATE UNIQUE INDEX M_INV_IDX ON M_inventory (IN_P_ID); */
