DROP TABLE C_customer;
CREATE TABLE C_customer
(
	C_ID		integer not null,
	C_FIRST		char(16),
	C_LAST		char(16),
	C_STREET1	char(20),	
	C_STREET2	char(20),	
	C_CITY		char(20),	
	C_STATE		char(2),	
	C_COUNTRY	char(10),	
	C_ZIP		char(9),	
	C_PHONE		char(16),
	C_CONTACT	char(25),	
	C_SINCE		date,
	C_BALANCE	numeric(9,2),
	C_CREDIT	char(2),
	C_CREDIT_LIMIT	numeric(9,2),
	C_YTD_PAYMENT	numeric(9,2),
	primary key (C_ID)
) TYPE = InnoDB;

/* CREATE UNIQUE INDEX C_C_IDX ON C_customer (C_ID); */

DROP TABLE C_supplier;
CREATE TABLE C_supplier
(
	SUPP_ID			integer not null,
	SUPP_NAME		char(16),
	SUPP_STREET1	char(20),	
	SUPP_STREET2	char(20),	
	SUPP_CITY		char(20),	
	SUPP_STATE		char(2),	
	SUPP_COUNTRY	char(10),	
	SUPP_ZIP		char(9),	
	SUPP_PHONE		char(16),
	SUPP_CONTACT	char(25),
	primary key (SUPP_ID)
) TYPE = InnoDB;

/* CREATE UNIQUE INDEX C_SUPP_IDX ON C_supplier (SUPP_ID); */

DROP TABLE C_site;
CREATE TABLE C_site
(
	SITE_ID			integer not null,
	SITE_NAME		char(16),
	SITE_STREET1	char(20),	
	SITE_STREET2	char(20),	
	SITE_CITY		char(20),	
	SITE_STATE		char(2),	
	SITE_COUNTRY	char(10),	
	SITE_ZIP		char(9),
	primary key (SITE_ID)
) TYPE = InnoDB;

/* CREATE UNIQUE INDEX C_SITE_IDX ON C_site (SITE_ID); */

DROP TABLE C_parts;
CREATE TABLE C_parts
(
	P_ID			char(15) not null,
	P_NAME			char(10),
	P_DESC			varchar(100),
	P_REV			char(6),
	P_UNIT			char(10),
	P_COST			numeric(9,2),
	P_PRICE			numeric(9,2),
	P_PLANNER		integer,
	P_TYPE			integer,
	P_IND			integer,
    P_LOMARK        integer,
    P_HIMARK        integer,
	primary key (P_ID)
) TYPE = InnoDB;

/* CREATE UNIQUE INDEX C_P_IDX ON C_parts (P_ID); */

DROP TABLE C_rule;
CREATE TABLE C_rule
(
	R_ID		varchar(20) not null,
	R_TEXT		long varchar,
	primary key (R_ID)
) TYPE = InnoDB;

/* CREATE UNIQUE INDEX C_R_IDX ON C_rule (R_ID); */

DROP TABLE C_discount;
CREATE TABLE C_discount
(	
	D_ID		varchar(64) not null,
	D_PERCENT	integer,
	primary key (D_ID)
) TYPE = InnoDB;

INSERT INTO C_discount (D_ID, D_PERCENT) VALUES
('PlatinumCustomer', 40);

INSERT INTO C_discount (D_ID, D_PERCENT) VALUES
('GoldCustomer', 30);

INSERT INTO C_discount (D_ID, D_PERCENT) VALUES
('SilverCustomer', 20);

INSERT INTO C_discount (D_ID, D_PERCENT) VALUES
('LongTimeCustomer', 10);

INSERT INTO C_discount (D_ID, D_PERCENT) VALUES
('FirstTimeCustomer', 15);

INSERT INTO C_discount (D_ID, D_PERCENT) VALUES
('JustACustomer', 0);

/* CREATE UNIQUE INDEX C_D_IDX ON C_discount (D_ID); */
